﻿using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Web.ModelBinding;
using NVCC.Models;

namespace NVCC.WebUI.Models
{
    public class HomePageViewModel
    {
        [DisplayName("Enter Patient SSN")]
        //[Required(ErrorMessage = "Enter a 9 digit number with or without spaces or dash separators")]
        //[RegularExpression("\\d[- ]*\\d[- ]*\\d[- ]*\\d[- ]*\\d[- ]*\\d[- ]*\\d[- ]*\\d[- ]*\\d",
        //    ErrorMessage = "Enter a 9 digit number (spaces and dashes are allowed)")]
        public string PatientSSN { get;  set;}

        [DisplayName("Station")]
        public short sta3n { get;  set; }

        [BindNever]
        public IEnumerable<UserFacility> ActiveFacilities { get; set; }

        [Display(Name = "Select to include VistA Imaging records in this REFDOC package.")]
        public bool IncludeVistAImaging { get; set; }
    }
}
